#ifndef IO_H
#define IO_H

#define MAX_RES  300
#define NO_COORD  -99999.999999999


/*
  the pdbres.use has now several values:
   USE_YES = use this residue, full coordinates, dia CS and outside cutoff
   USE_INCUTOFF = full coordinates, dia CS but inside cutoff
   USE_NO = don't use this residue. It either doesn't have coordinates in
            the structure or no dia CS are available
   USE_NOCS = residue has coordinates but no dia CS are available
*/
#define USE_INCUTOFF 2
#define USE_YES 1
#define USE_NO  0
#define USE_NOCS -1


typedef struct {
    MINT    use, iatomN, iatomH, iatomC;
    MFLOAT  xH, yH, zH, xN, yN, zN, xC, yC, zC;
    MFLOAT  csH, csN, csC;

    /* assignment of (up to 3) peaks along diagonal */
    MINT na, ia[3];

} pdbres;


pdbres *GetResidues(char *pdbname, MINT *nres, RPoint rm, MFLOAT cutoff);

MINT ReadDiaCS_sparky(char *filename, MINT nres, pdbres *res, MINT *is_3d);

MINT ReadDiaCS(char *filename, MINT nres, pdbres *res);

MINT ReadParaCS_sparky(char *filename, MINT *n_cs_para, MFLOAT *cs_paraH, MFLOAT *cs_paraN,
                       MFLOAT *cs_paraC, MINT *idx_para, MINT is_3d);

MINT InitialAssignment(MINT n_cs_para, MFLOAT *cs_paraH, MFLOAT *cs_paraN, MFLOAT *cs_paraC,
                       MINT nres, pdbres *res, MFLOAT width, MINT is_3d);

MINT ManualAssignment(char *filename, MINT n_cs_para, MFLOAT *cs_paraH,
                      MFLOAT *cs_paraN, MFLOAT *cs_paraC, MINT nres,
                      pdbres *res, MINT is_3d);

#endif
