# This is an example input for the automatic assignment
# of paramagnetic spectra
#
#
# In the first step an exhaustive 5 dimensional grid search
# over the tensor magnitude and orientation is performed,
# while the metal ion position is assumed to be fixed.
#
# angle rotation [degrees] (for rotational grid search)
5
#
# metal position x,y,z
17.032   4.428  14.324
#
# For initial assignment unique pairs of resonances along
# the diagonal are selected. Residues closer than a cutoff
# distance to the metal ion are excluded.
#
# width of diag, cutoff[nm]
0.0001  1.5
#
# Tensor magnitude search. For both the axial (Dax) and
# rhombic (Drh) component a start value, an end value and
# the number of discrete steps must be given
# 
# Dax  start, end, steps-1
-10000 0 20
#
# Drh  start, end, steps-1
-5000 0  10
#
# The cost function of the assignment is an error weighted
# sum of squares. The errors in the different dimensions are
# specified here:
#
# errorH, errorN, errorC
0.1 0.2 0.2
#
# After the 5D grid search but before the minimum cost assignment
# the tensor can be further optimised by minimisation. This allows
# that the tensor is not constraint to a discrete 5D gird.
#
# minimise (yes=1, no=0)
1
#
# Randomly chosen subsets from the initial assignment can be used
# as starting points for the assignment. The pseudo-random process
# must be seeded with a (large) integer and the number of subsets
# tested specified. A minimum number of initial peaks required is
# imposed (min_initial_peaks) and the number of assigned peaks in
# the subset (minpeaks) needs to be given.
# The number of iterations used to (hopefully) converge an assignment
# must be given.
# random seed, number of subset assignments
2703821   100
# number of iterations, min_initial_peaks, minpeaks
4  21  20
# Machine parameters
18.79		       # MACHINE_B0   
1.03e-10	       # DIST_NH      
2.0e-8                 # tau_r
1.2		       # G_FACTOR     
7.5		       # J_DY         
298		       # TEMPERATURE  
0.95		       # ORDER PARAMETER S^2
#
# distance restraint
# the digit turn on (1) and off (0) the distance restraint 
# if on, there is a distance restraint between the metal ion (mobil)
# and a fix point (coordinate given by x, y, z at the end):
# the distance must be bigger than radius1, and smaller than radius2.
# if not, a penalty energie cost apply, weigthed by the weigth.
# digit
  1
#radius1 raduis2 weigth
  8.0  16.0   100.0
# x y z
  7.828   6.612   5.528
