#ifndef MIN_H
#define MIN_H

#define SQR(a) ((a) == 0.0 ? 0.0 : (a)*(a))
#ifndef SIGN
#define	ABS(x) ((x) < 0 ? -(x) : (x))
#define SIGN(x,y) ((y) > 0.0 ? ABS(x) : -ABS(x))
#endif
/* #define SIGN(a,b) ((b) < 0 ? (-(a)) : (a)) */
#define FMAX(a,b) ((a) > (b) ? (a) : (b))

double *vector(long nl, long nh);

double **matrix(long nrl, long nrh, long ncl, long nch);

void free_vector(double *v, long nl, long nh);

void free_matrix(double **m, long nrl, long nrh, long ncl, long nch);

void powell(double p[], double **xi, int n, double ftol, int *iter, double *fret,
	double (*func)(double []));

#endif
