#ifndef PHYSCONST
#define PHYSCONST


/* constants from Guido
   some (like TEMPERATURE, &c.) should probably be parameters

where (in SI):
mu_0 /(4 * Pi): vacuum permeability: 10^-7
B-0: magnetic field: 14.11
gammaH (proton gyromagnetic ratio): 2.67 * 10^8;
gammaN (nitrogen gyromagnetic ratio): 2.71 * 10^7;
hbar (Plank constant/2Pi): 1.05 * 10^-34
r_iHN (proton-nitrogen distance in a HN pair): 1.03*10^-10;
taur (rotational correlation time): 4* 10^-9;
omegaH (H angular frequency): 2*Pi*600*10^6;
r_iH-Dy is the H-Dy distance;
mu_0 (vacuum permeability): (4 * Pi) * 10^-7 ;
mu_B (Bohr magneton): 9.27 * 10^-24;
ge (g factor): 4/3;
J (spin number of Dy): 15/2;
k (Boltzmann constant): 1.38 * 10^-23;
T : 298;

*/

#define MU0          1.2566370614359173e-06
#define MU0_DIV_4PI  1.0e-7
#define GAMMAH       2.67522212e+8
#define GAMMAN       -2.71e+7
#define MUB          9.27408e-24
#define KBOLTZ       1.38066e-23
#define HBAR         1.05459e-34

typedef struct Environment {
    MFLOAT machine_b0;
    MFLOAT dist_nh;
    MFLOAT tau_r;
    MFLOAT omega_h;                     /* machine_b0 * gammaH */
    MFLOAT g_factor;
    MFLOAT j_dy;
    MFLOAT temperature;
    MFLOAT order_param;
    MFLOAT ccr_factor, r1_factor, r2_factor, rdc_factor;
    MFLOAT thresh[4];
} Environment;

#endif
