#include <stdio.h>
#include <math.h>
#include <mydef.h>
#include <rmacros.h>
#include "racs.h"


MINT RACS(MFLOAT Aax, MFLOAT Arh, MFLOAT phi, MFLOAT psi, MFLOAT theta,
         RPoint rH, RPoint rN, RPoint rC, MFLOAT *deltaC,
         MFLOAT *deltaN, MFLOAT *deltaH, MFLOAT csC)
{

    MFLOAT     betaC, betaN, betaH;
    MFLOAT     cosbeta, sinbeta, cosbeta2, sinbeta2, cosbeta3, cosbeta4;
    MFLOAT     Hsig11, Hsig22, Hsig33;
    MFLOAT     Nsig11, Nsig22, Nsig33;
    MFLOAT     Csig11, Csig22, Csig33;
    MFLOAT     tmp, Axx, Ayy, Azz;
    MFLOAT     cosp, coss, cost, sinp, sins, sint;
    RPoint     normOG, normCN, normNH;
    RPoint     Cvec11, Cvec22, Cvec33;
    RPoint     Hvec11, Hvec22, Hvec33;
    RPoint     Nvec11, Nvec22, Nvec33;
    RPoint     exx, eyy, ezz, rCN, rOG, rNH;


    betaC = M_PI*38/180.0;              /* 38 degrees */
    betaN = M_PI*19/180.0;              /* 19 degrees */
    betaH = M_PI*8/180.0;               /*  8 degrees */
    Hsig11 = 5.8;
    Hsig22 = 0.0;
    Hsig33 = -5.8;
    Nsig11 = 108.5;
    Nsig22 = -45.7;
    Nsig33 = -62.8;
/*  --- values from Cornilescu & Bax JACS 122 (2000) 10149
    Csig11 = 74.7;
    Csig22 = 11.8;
    Csig33 = -86.5;
*/
/* --- site specific variation of C-CSA Markwick & Sattler
        JACS 126 (2004) 11424
 */
    Csig11 = 247;
    Csig22 = 3*csC - 332;
    Csig33 = 85;


    Axx = -Aax/3.0 + 0.5*Arh;
    Ayy = -Aax/3.0 - 0.5*Arh;
    Azz = 2*Aax/3.0;


    cosp = cos(phi);
    coss = cos(psi);
    cost = cos(theta);
    sinp = sin(phi);
    sins = sin(psi);
    sint = sin(theta);

    exx.x =  cosp*coss - cost*sinp*sins;
    exx.y = -cost*coss*sinp - cosp*sins;
    exx.z =  sint*sinp;

    eyy.x   = coss*sinp + cost*cosp*sins;
    eyy.y   = cost*cosp*coss - sinp*sins;
    eyy.z   = -cosp*sint;

    ezz.x   = sint*sins;
    ezz.y   = coss*sint;
    ezz.z   = cost;




    VECTOR_DIFFERENCE(rN, rC, rCN);
    tmp = VECTOR_LENGTH(rCN);
    normCN.x = rCN.x / tmp;
    normCN.y = rCN.y / tmp;
    normCN.z = rCN.z / tmp;
    VECTOR_DIFFERENCE(rH, rN, rNH);
    tmp = VECTOR_LENGTH(rNH);
    normNH.x = rNH.x / tmp;
    normNH.y = rNH.y / tmp;
    normNH.z = rNH.z / tmp;
    VECTOR_PRODUCT(rNH, rCN, rOG);
    tmp = VECTOR_LENGTH(rOG);
    normOG.x = rOG.x / tmp;
    normOG.y = rOG.y / tmp;
    normOG.z = rOG.z / tmp;



/* ###### Nitrogen RACS ####### */ 

    cosbeta  = cos(betaN);
    cosbeta4 = cos(betaN + 0.5*M_PI);
    cosbeta3 = 1 - cosbeta4;
    cosbeta2 = 1 - cosbeta;
    sinbeta  = sin(betaN);
    sinbeta2 = sin(betaN + 0.5*M_PI);

    Nvec11.x = (normOG.x*normOG.x*cosbeta2 + cosbeta) * normNH.x +
               (normOG.x*normOG.y*cosbeta2 + normOG.z*sinbeta) * normNH.y +
               (normOG.x*normOG.z*cosbeta2 - normOG.y*sinbeta) * normNH.z;

    Nvec11.y = (normOG.x*normOG.y*cosbeta2 - normOG.z*sinbeta) * normNH.x +
               (normOG.y*normOG.y*cosbeta2 + cosbeta) * normNH.y +
               (normOG.y*normOG.z*cosbeta2 + normOG.x*sinbeta) * normNH.z;

    Nvec11.z = (normOG.x*normOG.z*cosbeta2 + normOG.y*sinbeta) * normNH.x +
               (normOG.y*normOG.z*cosbeta2 - normOG.x*sinbeta) * normNH.y +
               (normOG.z*normOG.z*cosbeta2 + cosbeta) * normNH.z;


    Nvec22.x = normOG.x;
    Nvec22.y = normOG.y;
    Nvec22.z = normOG.z;


    Nvec33.x = (normOG.x*normOG.x*cosbeta3 + cosbeta4) * normNH.x +
               (normOG.x*normOG.y*cosbeta3 + normOG.z*sinbeta2)*normNH.y +
               (normOG.x*normOG.z*cosbeta3 - normOG.y*sinbeta2)*normNH.z;

    Nvec33.y = (normOG.x*normOG.y*cosbeta3 - normOG.z*sinbeta2)*normNH.x +
               (normOG.y*normOG.y*cosbeta3 + cosbeta4) * normNH.y +
               (normOG.y*normOG.z*cosbeta3 + normOG.x*sinbeta2)*normNH.z;

    Nvec33.z = (normOG.x*normOG.z*cosbeta3 + normOG.y*sinbeta2)*normNH.x +
               (normOG.y*normOG.z*cosbeta3 - normOG.x*sinbeta2)*normNH.y +
               (normOG.z*normOG.z*cosbeta3 + cosbeta4)*normNH.z;


    tmp = SCALAR_PRODUCT(Nvec11, exx);
    *deltaN = Nsig11 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Nvec11, eyy);
    *deltaN += Nsig11 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Nvec11, ezz);
    *deltaN += Nsig11 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Nvec22, exx);
    *deltaN += Nsig22 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Nvec22, eyy);
    *deltaN += Nsig22 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Nvec22, ezz);
    *deltaN += Nsig22 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Nvec33, exx);
    *deltaN += Nsig33 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Nvec33, eyy);
    *deltaN += Nsig33 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Nvec33, ezz);
    *deltaN += Nsig33 * tmp*tmp*Azz;


/* ###### Proton RACS ####### */ 


    cosbeta  = cos(betaH);
    cosbeta4 = 1 - cosbeta;
    cosbeta2 = cos(betaH - 0.5*M_PI);
    cosbeta3 = 1 - cosbeta2;
    sinbeta  = sin(betaH);
    sinbeta2 = sin(betaH - 0.5*M_PI);

    Hvec11.x = normOG.x;
    Hvec11.y = normOG.y;
    Hvec11.z = normOG.z;

    Hvec22.x = (normOG.x*normOG.x*cosbeta3 + cosbeta2) * normNH.x +
               (normOG.x*normOG.y*cosbeta3 + normOG.z*sinbeta2)*normNH.y +
               (normOG.x*normOG.z*cosbeta3 - normOG.y*sinbeta2)*normNH.z;

    Hvec22.y = (normOG.x*normOG.y*cosbeta3 - normOG.z*sinbeta2)*normNH.x +
               (normOG.y*normOG.y*cosbeta3 + cosbeta2) * normNH.y +
               (normOG.y*normOG.z*cosbeta3 + normOG.x*sinbeta2)*normNH.z;

    Hvec22.z = (normOG.x*normOG.z*cosbeta3 + normOG.y*sinbeta2)*normNH.x +
               (normOG.y*normOG.z*cosbeta3 - normOG.x*sinbeta2)*normNH.y +
               (normOG.z*normOG.z*cosbeta3 + cosbeta2) * normNH.z;


    Hvec33.x = (normOG.x*normOG.x*cosbeta4 + cosbeta) * normNH.x +
               (normOG.x*normOG.y*cosbeta4 + normOG.z*sinbeta)*normNH.y +
               (normOG.x*normOG.z*cosbeta4 - normOG.y*sinbeta)*normNH.z;

    Hvec33.y = (normOG.x*normOG.y*cosbeta4 - normOG.z*sinbeta)*normNH.x +
               (normOG.y*normOG.y*cosbeta4 + cosbeta)*normNH.y +
               (normOG.y*normOG.z*cosbeta4 + normOG.x*sinbeta)*normNH.z;

    Hvec33.z = (normOG.x*normOG.z*cosbeta4 + normOG.y*sinbeta)*normNH.x +
               (normOG.y*normOG.z*cosbeta4 - normOG.x*sinbeta)*normNH.y +
               (normOG.z*normOG.z*cosbeta4 + cosbeta)*normNH.z;


    tmp = SCALAR_PRODUCT(Hvec11, exx);
    *deltaH = Hsig11 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Hvec11, eyy);
    *deltaH += Hsig11 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Hvec11, ezz);
    *deltaH += Hsig11 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Hvec22, exx);
    *deltaH += Hsig22 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Hvec22, eyy);
    *deltaH += Hsig22 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Hvec22, ezz);
    *deltaH += Hsig22 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Hvec33, exx);
    *deltaH += Hsig33 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Hvec33, eyy);
    *deltaH += Hsig33 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Hvec33, ezz);
    *deltaH += Hsig33 * tmp*tmp*Azz;

/* ###### Carbon RACS ####### */ 

    cosbeta = cos(betaC);
    cosbeta4 = 1 - cosbeta;
    sinbeta = sin(betaC);

    cosbeta3 = cos(betaC+0.5*M_PI);
    cosbeta2 = 1 - cosbeta3;
    sinbeta2 = sin(betaC+0.5*M_PI);


    Cvec11.x = (normOG.x*normOG.x*cosbeta4 +cosbeta) * normCN.x +
               (normOG.x*normOG.y*cosbeta4 - normOG.z*sinbeta) * normCN.y +
               (normOG.x*normOG.z*cosbeta4 + normOG.y*sinbeta) * normCN.z;


    Cvec11.y = (normOG.x*normOG.y*cosbeta4 + normOG.z*sinbeta) * normCN.x +
               (normOG.y*normOG.y*cosbeta4 + cosbeta) * normCN.y+
               (normOG.y*normOG.z*cosbeta4 - normOG.x*sinbeta) * normCN.z;

    Cvec11.z = (normOG.x*normOG.z*cosbeta4 - normOG.y*sinbeta) * normCN.x+
               (normOG.y*normOG.z*cosbeta4 + normOG.x*sinbeta) * normCN.y+
               (normOG.z*normOG.z*cosbeta4 + cosbeta) * normCN.z;


    Cvec22.x = (normOG.x*normOG.x*cosbeta2 + cosbeta3)*normCN.x +
               (normOG.x*normOG.y*cosbeta2 - normOG.z*sinbeta2) * normCN.y +
               (normOG.x*normOG.z*cosbeta2 + normOG.y*sinbeta2) * normCN.z;
    
    Cvec22.y = (normOG.x*normOG.y*cosbeta2 + normOG.z*sinbeta2) * normCN.x+
               (normOG.y*normOG.y*cosbeta2 + cosbeta3)*normCN.y +
               (normOG.y*normOG.z*cosbeta2 - normOG.x*sinbeta2) * normCN.z;

    Cvec22.z = (normOG.x*normOG.z*cosbeta2 - normOG.y*sinbeta2)*normCN.x +
               (normOG.y*normOG.z*cosbeta2 + normOG.x*sinbeta2)*normCN.y +
               (normOG.z*normOG.z*cosbeta2 + cosbeta3)*normCN.z;

    
    Cvec33.x = normOG.x;
    Cvec33.y = normOG.y;
    Cvec33.z = normOG.z;


    tmp = SCALAR_PRODUCT(Cvec11, exx);
    *deltaC = Csig11 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Cvec11, eyy);
    *deltaC += Csig11 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Cvec11, ezz);
    *deltaC += Csig11 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Cvec22, exx);
    *deltaC += Csig22 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Cvec22, eyy);
    *deltaC += Csig22 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Cvec22, ezz);
    *deltaC += Csig22 * tmp*tmp*Azz;

    tmp = SCALAR_PRODUCT(Cvec33, exx);
    *deltaC += Csig33 * tmp*tmp*Axx;
    tmp = SCALAR_PRODUCT(Cvec33, eyy);
    *deltaC += Csig33 * tmp*tmp*Ayy;
    tmp = SCALAR_PRODUCT(Cvec33, ezz);
    *deltaC += Csig33 * tmp*tmp*Azz;

    return 0;
}

#ifdef TESTRACS
MINT main(MINT argc, char *argv[])
{
    MFLOAT     Aax, Arh, phi, psi, theta;
    RPoint     rH, rN, rC;
    MFLOAT     deltaH, deltaN, deltaC;

    Aax = 0.0011029;
    Arh = 0.0006394;
    phi   =  113.373 * M_PI/180.0;
    psi   =   63.128 * M_PI/180.0;
    theta = -149.374 * M_PI/180.0;


    fscanf(stdin, "%lf%lf%lf%lf%lf%lf%lf%lf%lf", &rN.x, &rN.y, &rN.z,
           &rH.x, &rH.y, &rH.z, &rC.x, &rC.y, &rC.z);


    RACS(Aax, Arh, phi, psi, theta, rH, rN, rC, &deltaC, &deltaN, &deltaH);

    fprintf(stdout, "%10.5f%10.5f%10.5f\n", deltaC, deltaN, deltaH);
    return 0;
}
#endif
