#include <stdio.h>
#include "mydef.h"
#include "sort.h"


void sort(MINT n, MFLOAT *a, MINT *idx)
{
    unsigned  int   i, j;
    MINT      itmp, itmp2;
    MFLOAT    temp, temp2;

    if (n <= 1)
        return;

    for (i = 1; i < n; ++i) {
        for (j = n - 1; j >= i; --j) {
            temp = a[j];
            temp2 = a[j - 1];
            itmp = idx[j];
            itmp2 = idx[j - 1];
            if (temp2 > temp) {
                a[j - 1] = temp;
                a[j] = temp2;
                idx[j - 1] = itmp;
                idx[j] = itmp2;
            }
        }
    }
}


void QuickSort( MFLOAT *A, MINT *idx, MINT l, MINT r)

/* Pre-condition: the array A is a list on [l..r] in some order.
 * Post-condition: the array A on [1..r] is in order.
 * Procedure: recursive QuickSort.  The last value is taken as a pivot,
 *  and its final position in the array is calculated.  Then the two
 *  halves of the array, those before the pivot and those after, are
 *  sorted using the same algorithm.  The base case of the recursion
 *  is when l=r, in which case the array of 1 element is in order as is.
 */       
  { MFLOAT pivot= A[r];
    MINT i = l-1;
    MINT j = r;
    MFLOAT temp;
    MINT tempidx,  pivotidx = idx[r];
            
    if (r>l)
      {
        do
          {
            do i++; while (A[i]<pivot);
            do j--; while ((j >= 0) && (A[j]>pivot));
            temp = A[i];
            A[i] = A[j];
            A[j] = temp;
            tempidx = idx[i];
            idx[i] = idx[j];
            idx[j] = tempidx;
          }
        while (j>i); 
        A[j] = A[i];
        A[i] = pivot;
        A[r] = temp;
        idx[j] = idx[i];
        idx[i] = pivotidx;
        idx[r] = tempidx;
        QuickSort(A,idx,l,i-1);
        QuickSort(A,idx,i+1,r);
      }
  }

void IQuickSort( MINT *A, MINT *idx, MINT l, MINT r)

/* Pre-condition: the array A is a list on [l..r] in some order.
 * Post-condition: the array A on [1..r] is in order.
 * Procedure: recursive QuickSort.  The last value is taken as a pivot,
 *  and its final position in the array is calculated.  Then the two
 *  halves of the array, those before the pivot and those after, are
 *  sorted using the same algorithm.  The base case of the recursion
 *  is when l=r, in which case the array of 1 element is in order as is.
 */       
  { MINT pivot= A[r];
    MINT i = l-1;
    MINT j = r;
    MINT temp;
    MINT tempidx,  pivotidx = idx[r];
            
    if (r>l)
      {
        do
          {
            do i++; while (A[i]<pivot);
            do j--; while ((j >= 0) && (A[j]>pivot));
            temp = A[i];
            A[i] = A[j];
            A[j] = temp;
            tempidx = idx[i];
            idx[i] = idx[j];
            idx[j] = tempidx;
          }
        while (j>i); 
        A[j] = A[i];
        A[i] = pivot;
        A[r] = temp;
        idx[j] = idx[i];
        idx[i] = pivotidx;
        idx[r] = tempidx;
        IQuickSort(A,idx,l,i-1);
        IQuickSort(A,idx,i+1,r);
      }
  }
